/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.Actiongram;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.MaterialQuantity;
import cz.insophy.inplan.shop.Product;
import cz.insophy.inplan.shop.ShopConfiguration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ProducingCycleDetector {
    private final ShopConfiguration conf;
    private final GroupedBy groupedBy;
    private final Multimap<Material, ActionLocation> producingMap;
    private final Deque<ActionLocation> actionPath;
    private final Deque<Material> materialPath;
    private List<CycleInfo> detectedCycles;

    public ProducingCycleDetector(ShopConfiguration conf, GroupedBy groupedBy) {
        this.producingMap = ProducingCycleDetector.buildProducingMap(conf);
        this.conf = conf;
        this.groupedBy = groupedBy;
        this.detectedCycles = Lists.newArrayList();
        this.materialPath = new ArrayDeque<Material>();
        this.actionPath = new ArrayDeque<ActionLocation>();
    }

    private static Multimap<Material, ActionLocation> buildProducingMap(ShopConfiguration conf) {
        ArrayListMultimap<Material, ActionLocation> map = ArrayListMultimap.create();
        for (Product p : conf.getProducts()) {
            for (Actiongram ag : p.getActiongrams()) {
                List<Action> actions = ag.getActions();
                int n = actions.size();
                for (int i = 0; i < n; ++i) {
                    Action a = actions.get(i);
                    for (MaterialQuantity mq : a.getProduces()) {
                        map.put(mq.getMaterial(), new ActionLocation(ag, i));
                    }
                }
            }
        }
        return map;
    }

    public Collection<CycleInfo> detectCycles() {
        Preconditions.checkState(this.actionPath.isEmpty(), "action path is not empty");
        Preconditions.checkState(this.materialPath.isEmpty(), "material path is not empty");
        this.detectedCycles.clear();
        for (Material p : this.conf.getMatprods()) {
            this.trace(p);
        }
        Preconditions.checkState(this.actionPath.isEmpty(), "action path is not empty");
        Preconditions.checkState(this.materialPath.isEmpty(), "material path is not empty");
        return this.detectedCycles;
    }

    private void trace(Material product) {
        this.materialPath.addLast(product);
        for (ActionLocation location : this.producingMap.get(product)) {
            if (location.isVisited()) continue;
            if (this.actionPath.contains(location)) {
                this.actionPath.addLast(location);
                this.detectedCycles.add(new CycleInfo(this.actionPath, this.materialPath));
            } else {
                this.actionPath.addLast(location);
                for (Material m3 : location.getIncomingMaterials(this.groupedBy)) {
                    this.trace(m3);
                }
                location.markVisited();
            }
            this.actionPath.removeLast();
        }
        this.materialPath.removeLast();
    }

    public static enum GroupedBy {
        ACTION,
        PRODUCT;

    }

    private static class ActionLocation {
        private final Actiongram actiongram;
        private final int actionIndex;
        private boolean visited;

        ActionLocation(Actiongram actiongram, int actionIndex) {
            this.actiongram = actiongram;
            this.actionIndex = actionIndex;
            this.visited = false;
        }

        Iterable<Material> getIncomingMaterials(GroupedBy groupedBy) {
            Set<Material> res = Sets.newIdentityHashSet();
            List<Action> actions = this.actiongram.getActions();
            int n = groupedBy == GroupedBy.ACTION ? this.actionIndex : this.actiongram.getActions().size() - 1;
            for (int i = 0; i <= n; ++i) {
                res.addAll(actions.get(i).getBom().materials());
            }
            return res;
        }

        void markVisited() {
            this.visited = true;
        }

        boolean isVisited() {
            return this.visited;
        }

        Action getAction() {
            return this.actiongram.getActions().get(this.actionIndex);
        }
    }

    public static class CycleInfo {
        private final List<Action> actions = Lists.newArrayList();
        private final List<Material> materials = Lists.newArrayList();

        CycleInfo(Deque<ActionLocation> actionPath, Deque<Material> materialPath) {
            ActionLocation cycled = actionPath.getLast();
            boolean started = false;
            Iterator<Material> matIter = materialPath.iterator();
            for (ActionLocation al : actionPath) {
                Material m3 = matIter.next();
                if (al == cycled) {
                    started = true;
                }
                if (!started) continue;
                this.actions.add(al.getAction());
                this.materials.add(m3);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.actions.size(); ++i) {
                Action a = this.actions.get(i);
                Material m3 = this.materials.get(i);
                sb.append(a.getProduct().getName());
                sb.append(" ");
                sb.append(a.getName());
                sb.append("\n ");
                if (i >= this.actions.size() - 1) continue;
                sb.append(m3.getName());
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

